/*  	BubbleMod commands Plugin  v1.0b */

#include <core>
#include <console>
#include <string>
#include <admin>
#include <adminlib>

#define ACCESS_LLAMA 8192

new STRING_VERSION[MAX_DATA_LENGTH] = "2.50.3";
public sv_handle(HLCommand,HLData,HLUserName,UserIndex) {

	new Command[MAX_COMMAND_LENGTH];
	new CommandPre[MAX_COMMAND_LENGTH];
	new CommandSuf[MAX_COMMAND_LENGTH];
	new Data[MAX_DATA_LENGTH];
	new User[MAX_NAME_LENGTH];

	convert_string(HLUserName,User,MAX_NAME_LENGTH);
	convert_string(HLCommand,Command,MAX_COMMAND_LENGTH);
	convert_string(HLData,Data,MAX_DATA_LENGTH);

	strsplit(Command,"_", CommandPre, MAX_DATA_LENGTH, CommandSuf, MAX_DATA_LENGTH);
	execute_command(User, Command, CommandSuf, Data);

	return PLUGIN_HANDLED;
}

public passthru(HLCommand,HLData,HLUserName,UserIndex) {

	return PLUGIN_HANDLED;
}	

public plugin_init() {
	plugin_registerinfo("BubbleMod Commands","Access to BubbleMod server commands",STRING_VERSION);
	plugin_registercmd("bm_s","sv_handle",ACCESS_RCON,"bm_s 'message': RCON style say.");
	plugin_registercmd("bm_w","sv_handle",ACCESS_RCON,"bm_w <UID> 'message': BubbleMod whisper to <UID>.");
	plugin_registercmd("bm_markspawnpoints","sv_handle",ACCESS_RCON,"bm_markspawnpoints: Shows spawn points as a green box.");
	plugin_registercmd("bm_sspeak","sv_handle",ACCESS_SAY,"bm_sspeak 'message': Uses vox to speak 'message'.");
	plugin_registercmd("bm_llama","sv_handle",ACCESS_LLAMA,"bm_llama <UID>: BubbleMod style llama.");		
	plugin_registercmd("bm_unllama","sv_handle",ACCESS_LLAMA,"bm_unllama <UID>: BubbleMod style unllama.");	
	plugin_registercmd("bm_create","sv_handle",ACCESS_RCON,"bm_create <entity> <x pos> <y pos> <z pos> <facing>: Create <entity> at (x,y,z) with <facing>.");
	plugin_registercmd("bm_remove","sv_handle",ACCESS_RCON,"bm_remove <entity>: Remove all instances of <entity> from the current map.");
	plugin_registercmd("bm_replace","sv_handle",ACCESS_RCON,"bm_replace <oldentity> <newentity>: Replace all instances of <entityold> with <entitynew> in the current map.");

	plugin_registercmd("bm_locate","passthru",ACCESS_ALL,"locate: Toggles location on HUD.");
	plugin_registercmd("bm_leetspeak","passthru",ACCESS_ALL,"leetspeak: Toggles BubbleMod style leetspeak.");
	plugin_registercmd("bm_say_timeleft","passthru",ACCESS_ALL,"say timeleft: Will echo time remaining on current map.");
	plugin_registercmd("bm_say_fragsleft","passthru",ACCESS_ALL,"say fragsleft: Will echo frags remaining on current map.");
	plugin_registercmd("bm_say_map","passthru",ACCESS_ALL,"say map: Will echo current and next maps.");
  	plugin_registercmd("bm_say_status","passthru",ACCESS_ALL,"say status: Will echo timeleft, fragsleft, and map names.");
	return PLUGIN_CONTINUE;
}